------------------------------------------------------------------------------------------------------------------------------------
function createDefenderArmies()
	--TowerDefenders -> Bombarmy
	TowerDefenders = UnlimitedArmy:New({
					Player = 2,
					Area = 4200,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Lines,
					LeaderFormation = 4,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	TowerDefendersGenerator = UnlimitedArmySpawnGenerator:New(TowerDefenders,{
							Position = GetPosition("army1"),
							ArmySize = 8,
							SpawnCounter = 90,
							SpawnLeaders = 8,
							LeaderDesc = {
							{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 2, Looped = true, Experience = 3}
							},
							Generator = "spawny1"
							})
							
	TowerDefenders:AddCommandDefend(GetPosition("defpos"),5000,true)
	
	IronMineDefenders = UnlimitedArmy:New({
					Player = 2,
					Area = 4200,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Lines,
					LeaderFormation = 4,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	IronMineDefendersGenerator = UnlimitedArmySpawnGenerator:New(IronMineDefenders,{
							Position = GetPosition("army2"),
							ArmySize = 13,
							SpawnCounter = 60,
							SpawnLeaders = 13,
							LeaderDesc = {
							{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 2, Looped = true, Experience = 3}
							},
							Generator = "MineTower"
							})
	IronMineDefenders:AddCommandDefend(GetPosition("army2"),12000,true)
	
	DZPatrol = UnlimitedArmy:New({
					Player = 2,
					Area = 3600,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					LeaderFormation = 4,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderCavalry2, 3, GetPosition("patroul1"), 3)
	DZPatrol:CreateLeaderForArmy(Entities.PU_LeaderCavalry2, 3, GetPosition("patroul1"), 3)
	
	DZPatrol:AddCommandMove(GetPosition("patroul1"),true)
	DZPatrol:AddCommandWaitForIdle(true)
	DZPatrol:AddCommandMove(GetPosition("patroul2"),true)
	DZPatrol:AddCommandWaitForIdle(true)
	DZPatrol:AddCommandMove(GetPosition("patroul3"),true)
	DZPatrol:AddCommandWaitForIdle(true)
	DZPatrol:AddCommandMove(GetPosition("patroul4"),true)
	DZPatrol:AddCommandWaitForIdle(true)
	DZPatrol:AddCommandMove(GetPosition("patroul5"),true)
	DZPatrol:AddCommandWaitForIdle(true)
	DZPatrol:AddCommandMove(GetPosition("patroul4"),true)
	DZPatrol:AddCommandWaitForIdle(true)
	DZPatrol:AddCommandMove(GetPosition("patroul3"),true)
	DZPatrol:AddCommandWaitForIdle(true)
	DZPatrol:AddCommandMove(GetPosition("patroul2"),true)
	DZPatrol:AddCommandWaitForIdle(true)
	
	firstDef = UnlimitedArmy:New({
					Player = 2,
					Area = 4500,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Lines,
					LeaderFormation = 4,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = false
					})
	firstDef.SpawnCounter = 150
	firstDef.EntityCounter = 0
	firstDef:AddCommandLuaFunc(BridgeCheck,true)
	
	local spawntable1 = {}
	spawntable1[1] = GetPosition("army5")
	spawntable1[1].Generator = "firstdefTower"
	spawntable1[2] = GetPosition("army6spawn")
	spawntable1[2].Generator = "seconddefTower"
	
	firstDefinner = UnlimitedArmy:New({
					Player = 2,
					Area = 4500,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					LeaderFormation = 4,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	firstDefinnerGenerator = UnlimitedArmySpawnGenerator:New(firstDefinner,{
							Position = spawntable1,
							ArmySize = 4,
							SpawnCounter = 180,
							SpawnLeaders = 4,
							LeaderDesc = {
							{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							}
							})
	firstDefinner:AddCommandMove(GetPosition("army5"),true)
	firstDefinner:AddCommandWaitForIdle(true)
	firstDefinner:AddCommandLuaFunc(RefillSoldiers,true)
	firstDefinner:AddCommandMove(GetPosition("firstdefinner1"),true)
	firstDefinner:AddCommandWaitForIdle(true)
	firstDefinner:AddCommandLuaFunc(RefillSoldiers,true)
	
	firstDefRangeinner = UnlimitedArmy:New({
					Player = 2,
					Area = 4500,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					LeaderFormation = 4,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	firstDefRangeinnerGenerator = UnlimitedArmySpawnGenerator:New(firstDefRangeinner,{
							Position = spawntable1,
							ArmySize = 4,
							SpawnCounter = 180,
							SpawnLeaders = 4,
							LeaderDesc = {
							{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderRifle1, SoldierNum = 4, SpawnNum = 3, Looped = true, Experience = 3},
							}
							})
	firstDefRangeinner:AddCommandMove(GetPosition("army5"),true)
	firstDefRangeinner:AddCommandWaitForIdle(true)
	firstDefRangeinner:AddCommandLuaFunc(RefillSoldiers,true)
	firstDefRangeinner:AddCommandMove(GetPosition("firstdefinner1"),true)
	firstDefRangeinner:AddCommandWaitForIdle(true)
	firstDefRangeinner:AddCommandLuaFunc(RefillSoldiers,true)
	
	lastDef = UnlimitedArmy:New({
					Player = 2,
					Area = 4500,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					LeaderFormation = 4,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	local spawntable2 = {}
	spawntable2[1] = GetPosition("army6spawn")
	spawntable2[1].Generator = {"firstdefTower","seconddefTower"}
	lastDefGenerator = UnlimitedArmySpawnGenerator:New(lastDef, {
							Position = spawntable2,
							ArmySize = 6,
							SpawnCounter = 60,
							SpawnLeaders = 6,
							LeaderDesc = {
							{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							}
							})
	lastDef:AddCommandMove(GetPosition("army6spawn"),true)
	lastDef:AddCommandWaitForIdle(true)
	lastDef:AddCommandLuaFunc(RefillSoldiers,true)
	lastDef:AddCommandMove(GetPosition("army6"),true)
	lastDef:AddCommandWaitForIdle(true)
	lastDef:AddCommandLuaFunc(RefillSoldiers,true)
	
	lastDefRange = UnlimitedArmy:New({
					Player = 2,
					Area = 4500,
					AutoDestroyIfEmpty = true,
					TransitAttackMove = true,
					Formation = UnlimitedArmy.Formations.Chaotic,
					LeaderFormation = 4,
					AIActive = true,
					AutoRotateRange = 1000000,
					DoNotNormalizeSpeed = true
					})
	local spawntable2 = {}
	spawntable2[1] = GetPosition("army6spawn")
	spawntable2[1].Generator = {"firstdefTower","seconddefTower"}
	lastDefGenerator = UnlimitedArmySpawnGenerator:New(lastDefRange, {
							Position = spawntable2,
							ArmySize = 6,
							SpawnCounter = 60,
							SpawnLeaders = 6,
							LeaderDesc = {
							{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PV_Cannon4, SoldierNum = 0, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderRifle1, SoldierNum = 4, SpawnNum = 3, Looped = true, Experience = 3},
							}
							})
	lastDefRange:AddCommandMove(GetPosition("army6spawn"),true)
	lastDefRange:AddCommandWaitForIdle(true)
	lastDefRange:AddCommandLuaFunc(RefillSoldiers,true)
	lastDefRange:AddCommandMove(GetPosition("army6"),true)
	lastDefRange:AddCommandWaitForIdle(true)
	lastDefRange:AddCommandLuaFunc(RefillSoldiers,true)
	
	local 	troopsDefender = {
        Entities.PU_LeaderSword3,
		Entities.PU_LeaderBow3,
    	}
	tentarmy = {}
	
	createArmy(2,8,tentarmy,5,"armytent",VERYHIGH_EXPERIENCE,troopsDefender,500)
	firstDef:GetPosition()
	StartSimpleJob("TentController")
end
------------------------------------------------------------------------------------------------------------------------------------
function RefillSoldiers(self)
	for id in self:Iterator(true) do
		if Logic.IsLeader(id)==1 and Logic.LeaderGetMaxNumberOfSoldiers(id)>0 and Logic.LeaderGetNumberOfSoldiers(id)<4 then
			Tools.CreateSoldiersForLeader(id, 4-Logic.LeaderGetNumberOfSoldiers(id))
		end
	end
	return true
end
function BridgeCheck(self)
	if self:GetPosition() == invalidPosition then
		self.UAPos = UADefGetPosition()
	else
		self.UAPos = self:GetPosition()
	end
	--local bridgepos = GetPosition("patroul1")
	--local bridgeT = {Logic.GetEntitiesInArea(Entities.PB_Bridge1, bridgepos.X, bridgepos.Y, 3000, 1)}
	--if bridgeT[1] > 0 and Logic.IsConstructionComplete(bridgeT[2]) == 1 then
	if Logic.GetSector(Logic.GetEntityIDByName("player1")) == Logic.GetSector(Logic.GetEntityIDByName("outsidespawn")) then
		if SpawnPos() then
			if self.SpawnCounter <= 0 then
				for i = 1,12,1 do
					
					if math.mod(self.EntityCounter,3) == 0 then
						self:CreateLeaderForArmy(Entities.PU_LeaderSword4, 8, SpawnPos(), 3)
					else
						self:CreateLeaderForArmy(Entities.PU_LeaderRifle1, 4, SpawnPos(), 3)
					end
					self.EntityCounter = self.EntityCounter + 1
					if self.EntityCounter >= 9 then
						self.EntityCounter = 0
					end
				end
				self.SpawnCounter = 150
			else
				self.SpawnCounter = self.SpawnCounter - 1
			end
		end
		if self:GetSize(false,false) > table.getn(self.LeaderTransit) then
			if UASimpleIdle(self) then
				return true, UnlimitedArmy.CreateCommandMove(GetPosition("player1"))
			end
		else
			return true, UnlimitedArmy.CreateCommandDefend(self.UAPos,4500)
		end
		return true
	else
		if self:GetSize(true,false) < 12 then
			for i = 1,12-self:GetSize(true,false),1 do
				if math.mod(self.EntityCounter,3) == 0 then
						self:CreateLeaderForArmy(Entities.PU_LeaderSword4, 8, SpawnPos(), 3)
				else
					self:CreateLeaderForArmy(Entities.PU_LeaderRifle1, 4, SpawnPos(), 3)
				end
				self.EntityCounter = self.EntityCounter + 1
				if self.EntityCounter >= 9 then
					self.EntityCounter = 0
				end
			end
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("army4"))
		end
			if self:IsIdle() then
				if GetDistance(self:GetPosition(),"army4") <= 1000 then
					return true, UnlimitedArmy.CreateCommandMove(GetPosition("army4outerpoint"))
				elseif GetDistance(self:GetPosition(),"army4outerpoint") <= 1000 then
					return true, UnlimitedArmy.CreateCommandMove(GetPosition("army4"))
				end
			end
	end
	return false
end

function UADefGetPosition()
	return GetPosition("army4outerpoint")
end

function SpawnPos()
	if IsAlive("control1") then
		return GetPosition("outsidespawn")
	end
	if IsAlive("firstdefTower") then
		return GetPosition("army5")
	end
	if IsAlive("control3") then
		return GetPosition("outsidespawn")
	end
	if IsAlive("seconddefTower") then
		return GetPosition("army6spawn")
	end
	return false
end

function UASimpleIdle(self)
	if self.Status ~= UnlimitedArmy.Status.Idle then
		return false
	end
	if GetDistance(self:GetPosition(), self.Target)>1000 then
		return false
	end
	for _,id in ipairs(self.Leaders) do
		if not UnlimitedArmy.IsLeaderIdle(id) then
			return false
		end
	end
	return true
end

function TentController()
	if IsDead(tentarmy) then
		return true
	end
	Defend(tentarmy)
	return false
end
